/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public abstract class BaseElectricTileEntity
extends SmartTileEntity
implements EnergyTransferable {
    protected final InternalEnergyStorage energy;
    protected LazyOptional<EnergyStorage> lazyEnergy;
    private boolean firstTickState = true;
    protected final long CAPACITY;
    protected final long MAX_IN;
    protected final long MAX_OUT;
    private LazyOptional<EnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheWest = LazyOptional.empty();

    public BaseElectricTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state, long CAPACITY, long MAX_IN, long MAX_OUT) {
        super(tileEntityTypeIn, pos, state);
        this.energy = new InternalEnergyStorage(CAPACITY, MAX_IN, MAX_OUT);
        this.CAPACITY = CAPACITY;
        this.MAX_IN = MAX_IN;
        this.MAX_OUT = MAX_OUT;
        this.lazyEnergy = LazyOptional.of(() -> this.energy);
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    @Nullable
    public EnergyStorage getEnergyStorage(@Nullable class_2350 side) {
        if (this.isEnergyInput(side) || this.isEnergyOutput(side)) {
            return (EnergyStorage)this.lazyEnergy.getValueUnsafer();
        }
        return null;
    }

    public abstract boolean isEnergyInput(class_2350 var1);

    public abstract boolean isEnergyOutput(class_2350 var1);

    protected void read(class_2487 compound, boolean arg1) {
        super.read(compound, arg1);
        this.energy.read(compound);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
    }

    @Deprecated
    public void outputTick(int max) {
        for (class_2350 side : class_2350.values()) {
            if (!this.isEnergyOutput(side)) continue;
            this.energy.outputToSide(this.field_11863, this.field_11867, side, max);
        }
    }

    public void tick() {
        super.tick();
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.field_11863 != null) {
            if (this.field_11863.field_9236) {
                return;
            }
            for (class_2350 side : class_2350.values()) {
                class_2586 te = this.field_11863.method_8321(this.field_11867.method_10093(side));
                if (te == null) {
                    this.setCache(side, (LazyOptional<EnergyStorage>)LazyOptional.empty());
                    continue;
                }
                LazyOptional le = LazyOptional.ofObject((Object)((EnergyStorage)EnergyStorage.SIDED.find(te.method_10997(), te.method_11016(), (Object)side.method_10153())));
                this.setCache(side, (LazyOptional<EnergyStorage>)le);
            }
        }
    }

    public void setCache(class_2350 side, LazyOptional<EnergyStorage> storage) {
        switch (side) {
            case field_11033: {
                this.escacheDown = storage;
                break;
            }
            case field_11034: {
                this.escacheEast = storage;
                break;
            }
            case field_11043: {
                this.escacheNorth = storage;
                break;
            }
            case field_11035: {
                this.escacheSouth = storage;
                break;
            }
            case field_11036: {
                this.escacheUp = storage;
                break;
            }
            case field_11039: {
                this.escacheWest = storage;
            }
        }
    }

    public EnergyStorage getCachedEnergy(class_2350 side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> (EnergyStorage)this.escacheDown.orElse(null);
            case class_2350.field_11034 -> (EnergyStorage)this.escacheEast.orElse(null);
            case class_2350.field_11043 -> (EnergyStorage)this.escacheNorth.orElse(null);
            case class_2350.field_11035 -> (EnergyStorage)this.escacheSouth.orElse(null);
            case class_2350.field_11036 -> (EnergyStorage)this.escacheUp.orElse(null);
            case class_2350.field_11039 -> (EnergyStorage)this.escacheWest.orElse(null);
        };
    }
}

